﻿using System;
using System.Security.Principal;

using Framework.Web;
using System.IO;
using Sample1.Master;

namespace Sample1
{
    public class Global : System.Web.HttpApplication
    {
        /// <summary>
        /// Application_Start
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Application_Start(object sender, EventArgs e)
        {
            //ログ設定
            var path = Server.MapPath("Log.Config");
            Framework.Log.LogConfigurator.Configure(path);

            //マスタデータのリクエストリスナを登録
            Framework.Data.AppSetting.SetListener(new AppSettingListener());
            LTextMgr.SetListener(new LTextSrcListener());
            ListMgr.SetListener(new ListSrcListener());
        }

        /// <summary>
        /// Application_Error
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Application_Error(object sender, EventArgs e)
        {
            //favicon.ico が見つからないときのエラーは無視する。
            var ctx = System.Web.HttpContext.Current;
            if (ctx != null && ctx.Request.Path.EndsWith("favicon.ico"))
            {
                return;
            }

            //ログ出力
            Framework.Log.LoggerPool.GetLogger().Fatal("その他の例外", Server.GetLastError());

#if DEBUG
#else
            //エラー画面へ
            Response.Redirect("Error.htm");
#endif

        }

        /// <summary>
        /// Session_Start
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Session_Start(object sender, EventArgs e)
        {
            //セッションタイムアウトの検出を開始します。
            SessionMgr.StartTimeoutDetect();
        }

        /// <summary>
        /// Session_End
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {

        }
    }
}